import { TransportItemType } from '../../transports';
export function initializeTracesAPI(_transports, _metas) {
    let otel = undefined;
    const initOTEL = (trace, context) => {
        otel = {
            trace,
            context,
        };
    };
    const getTraceContext = () => {
        if (otel) {
            const ctx = otel.trace.getSpanContext(otel.context.active());
            if (ctx) {
                return {
                    trace_id: ctx.traceId,
                    span_id: ctx.spanId,
                };
            }
        }
        return undefined;
    };
    const pushTraces = (request) => {
        try {
            const item = {
                type: TransportItemType.TRACE,
                payload: request,
                meta: _metas.value,
            };
            _transports.execute(item);
        }
        catch (err) {
            // TODO: Add proper logging when debug is enabled
        }
    };
    const getOTEL = () => otel;
    const bag = {
        initOTEL,
        pushTraces,
        getTraceContext,
        getOTEL,
    };
    return bag;
}
//# sourceMappingURL=initialize.js.map