import { ComponentClass } from 'react';
import { KeyValue } from './data';
import { NavModel } from './navModel';
import { PluginMeta, GrafanaPlugin } from './plugin';
export declare enum CoreApp {
    Dashboard = "dashboard",
    Explore = "explore"
}
export interface AppRootProps<T = KeyValue> {
    meta: AppPluginMeta<T>;
    path: string;
    query: KeyValue;
    /**
     * Pass the nav model to the container... is there a better way?
     */
    onNavChanged: (nav: NavModel) => void;
}
export interface AppPluginMeta<T = KeyValue> extends PluginMeta<T> {
}
export declare class AppPlugin<T = KeyValue> extends GrafanaPlugin<AppPluginMeta<T>> {
    root?: ComponentClass<AppRootProps<T>>;
    rootNav?: NavModel;
    angularPages?: {
        [component: string]: any;
    };
    /**
     * Called after the module has loaded, and before the app is used.
     * This function may be called multiple times on the same instance.
     * The first time, `this.meta` will be undefined
     */
    init(meta: AppPluginMeta): void;
    /**
     * Set the component displayed under:
     *   /a/${plugin-id}/*
     *
     * If the NavModel is configured, the page will have a managed frame, otheriwse it has full control.
     *
     * NOTE: this structure will change in 7.2+ so that it is managed with a normal react router
     */
    setRootPage(root: ComponentClass<AppRootProps<T>>, rootNav?: NavModel): this;
    setComponentsFromLegacyExports(pluginExports: any): void;
}
/**
 * Defines life cycle of a feature
 * @internal
 */
export declare enum FeatureState {
    alpha = "alpha",
    beta = "beta"
}
