# System.Data

``` diff
+namespace System.Data {
+    public enum CommandBehavior {
+        CloseConnection = 32,
+        Default = 0,
+        KeyInfo = 4,
+        SchemaOnly = 2,
+        SequentialAccess = 16,
+        SingleResult = 1,
+        SingleRow = 8,
+    }
+    public enum CommandType {
+        StoredProcedure = 4,
+        TableDirect = 512,
+        Text = 1,
+    }
+    public enum ConnectionState {
+        Broken = 16,
+        Closed = 0,
+        Connecting = 2,
+        Executing = 4,
+        Fetching = 8,
+        Open = 1,
+    }
+    public enum DataRowVersion {
+        Default = 1536,
+    }
+    public class DataTable
+    public enum DbType {
+        AnsiString = 0,
+        AnsiStringFixedLength = 22,
+        Binary = 1,
+        Boolean = 3,
+        Byte = 2,
+        Currency = 4,
+        Date = 5,
+        DateTime = 6,
+        DateTime2 = 26,
+        DateTimeOffset = 27,
+        Decimal = 7,
+        Double = 8,
+        Guid = 9,
+        Int16 = 10,
+        Int32 = 11,
+        Int64 = 12,
+        Object = 13,
+        SByte = 14,
+        Single = 15,
+        String = 16,
+        StringFixedLength = 23,
+        Time = 17,
+        UInt16 = 18,
+        UInt32 = 19,
+        UInt64 = 20,
+        VarNumeric = 21,
+        Xml = 25,
+    }
+    public interface IDataParameter {
+        DbType DbType { get; set; }
+        ParameterDirection Direction { get; set; }
+        bool IsNullable { get; }
+        string ParameterName { get; set; }
+        string SourceColumn { get; set; }
+        DataRowVersion SourceVersion { get; set; }
+        object Value { get; set; }
+    }
+    public interface IDataParameterCollection : ICollection, IEnumerable, IList {
+        object this[string parameterName] { get; set; }
+        bool Contains(string parameterName);
+        int IndexOf(string parameterName);
+        void RemoveAt(string parameterName);
+    }
+    public interface IDataReader : IDataRecord, IDisposable {
+        int Depth { get; }
+        bool IsClosed { get; }
+        int RecordsAffected { get; }
+        void Close();
+        DataTable GetSchemaTable();
+        bool NextResult();
+        bool Read();
+    }
+    public interface IDataRecord {
+        int FieldCount { get; }
+        object this[int i] { get; }
+        object this[string name] { get; }
+        bool GetBoolean(int i);
+        byte GetByte(int i);
+        long GetBytes(int i, long fieldOffset, byte[] buffer, int bufferoffset, int length);
+        char GetChar(int i);
+        long GetChars(int i, long fieldoffset, char[] buffer, int bufferoffset, int length);
+        IDataReader GetData(int i);
+        string GetDataTypeName(int i);
+        DateTime GetDateTime(int i);
+        decimal GetDecimal(int i);
+        double GetDouble(int i);
+        Type GetFieldType(int i);
+        float GetFloat(int i);
+        Guid GetGuid(int i);
+        short GetInt16(int i);
+        int GetInt32(int i);
+        long GetInt64(int i);
+        string GetName(int i);
+        int GetOrdinal(string name);
+        string GetString(int i);
+        object GetValue(int i);
+        int GetValues(object[] values);
+        bool IsDBNull(int i);
+    }
+    public interface IDbCommand : IDisposable {
+        string CommandText { get; set; }
+        int CommandTimeout { get; set; }
+        CommandType CommandType { get; set; }
+        IDbConnection Connection { get; set; }
+        IDataParameterCollection Parameters { get; }
+        IDbTransaction Transaction { get; set; }
+        UpdateRowSource UpdatedRowSource { get; set; }
+        void Cancel();
+        IDbDataParameter CreateParameter();
+        int ExecuteNonQuery();
+        IDataReader ExecuteReader();
+        IDataReader ExecuteReader(CommandBehavior behavior);
+        object ExecuteScalar();
+        void Prepare();
+    }
+    public interface IDbConnection : IDisposable {
+        string ConnectionString { get; set; }
+        int ConnectionTimeout { get; }
+        string Database { get; }
+        ConnectionState State { get; }
+        IDbTransaction BeginTransaction();
+        IDbTransaction BeginTransaction(IsolationLevel il);
+        void ChangeDatabase(string databaseName);
+        void Close();
+        IDbCommand CreateCommand();
+        void Open();
+    }
+    public interface IDbDataParameter : IDataParameter {
+        byte Precision { get; set; }
+        byte Scale { get; set; }
+        int Size { get; set; }
+    }
+    public interface IDbTransaction : IDisposable {
+        IDbConnection Connection { get; }
+        IsolationLevel IsolationLevel { get; }
+        void Commit();
+        void Rollback();
+    }
+    public enum IsolationLevel {
+        Chaos = 16,
+        ReadCommitted = 4096,
+        ReadUncommitted = 256,
+        RepeatableRead = 65536,
+        Serializable = 1048576,
+        Snapshot = 16777216,
+        Unspecified = -1,
+    }
+    public enum ParameterDirection {
+        Input = 1,
+        InputOutput = 3,
+        Output = 2,
+        ReturnValue = 6,
+    }
+    public enum SqlDbType {
+        BigInt = 0,
+        Binary = 1,
+        Bit = 2,
+        Char = 3,
+        Date = 31,
+        DateTime = 4,
+        DateTime2 = 33,
+        DateTimeOffset = 34,
+        Decimal = 5,
+        Float = 6,
+        Image = 7,
+        Int = 8,
+        Money = 9,
+        NChar = 10,
+        NText = 11,
+        NVarChar = 12,
+        Real = 13,
+        SmallDateTime = 15,
+        SmallInt = 16,
+        SmallMoney = 17,
+        Structured = 30,
+        Text = 18,
+        Time = 32,
+        Timestamp = 19,
+        TinyInt = 20,
+        Udt = 29,
+        UniqueIdentifier = 14,
+        VarBinary = 21,
+        VarChar = 22,
+        Variant = 23,
+        Xml = 25,
+    }
+    public sealed class StateChangeEventArgs : EventArgs {
+        public StateChangeEventArgs(ConnectionState originalState, ConnectionState currentState);
+        public ConnectionState CurrentState { get; }
+        public ConnectionState OriginalState { get; }
+    }
+    public delegate void StateChangeEventHandler(object sender, StateChangeEventArgs e);
+    public sealed class StatementCompletedEventArgs : EventArgs {
+        public StatementCompletedEventArgs(int recordCount);
+        public int RecordCount { get; }
+    }
+    public delegate void StatementCompletedEventHandler(object sender, StatementCompletedEventArgs e);
+    public enum UpdateRowSource {
+        Both = 3,
+        FirstReturnedRecord = 2,
+        None = 0,
+        OutputParameters = 1,
+    }
+}
```

