function(test_environment_variable name expected_value)
  string(REGEX MATCH "${name}=([^\n]*)" REGEX_RESULT "${actual_stdout}")
  if(NOT REGEX_RESULT)
    string(APPEND RunCMake_TEST_FAILED "Environment variable '${name}' is not defined.\n")
  else()
    set(actual_value "${CMAKE_MATCH_1}")
    if(NOT "${actual_value}" MATCHES "${expected_value}")
      string(REPLACE "\n" "\n  " _actual "${expected_value}")
      string(REPLACE "\n" "\n  " _expect "${actual_value}")
      string(APPEND RunCMake_TEST_FAILED "Expected value of environment variable '${name}':\n  ${_expect}\nActual value:\n  ${_actual}\n")
    endif()
  endif()
  set(RunCMake_TEST_FAILED "${RunCMake_TEST_FAILED}" PARENT_SCOPE)
endfunction()
