﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/guardduty/model/UpdateMalwareScanSettingsRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::GuardDuty::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

UpdateMalwareScanSettingsRequest::UpdateMalwareScanSettingsRequest() : 
    m_detectorIdHasBeenSet(false),
    m_scanResourceCriteriaHasBeenSet(false),
    m_ebsSnapshotPreservation(EbsSnapshotPreservation::NOT_SET),
    m_ebsSnapshotPreservationHasBeenSet(false)
{
}

Aws::String UpdateMalwareScanSettingsRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_scanResourceCriteriaHasBeenSet)
  {
   payload.WithObject("scanResourceCriteria", m_scanResourceCriteria.Jsonize());

  }

  if(m_ebsSnapshotPreservationHasBeenSet)
  {
   payload.WithString("ebsSnapshotPreservation", EbsSnapshotPreservationMapper::GetNameForEbsSnapshotPreservation(m_ebsSnapshotPreservation));
  }

  return payload.View().WriteReadable();
}




