/* SPDX-License-Identifier: GPL-2.0 or BSD-3-Clause */

/* Authors: Cheng Xu <chengyou@linux.alibaba.com> */
/*          Kai Shen <kaishen@linux.alibaba.com> */
/* Copyright (c) 2020-2022, Alibaba Group. */

#ifndef __ERDMA_STATS_H__
#define __ERDMA_STATS_H__

#include "kcompat.h"
#include <rdma/ib_verbs.h>

#define ERDMA_INC_CNT(dev, name) \
	atomic64_inc(&dev->stats.value[ERDMA_STATS_##name])

enum erdma_hw_stats_index {
	ERDMA_STATS_IW_LISTEN_CREATE = 0,
	ERDMA_STATS_IW_LISTEN_IPV6,
	ERDMA_STATS_IW_LISTEN_SUCCESS,
	ERDMA_STATS_IW_LISTEN_FAILED,
	ERDMA_STATS_IW_LISTEN_DESTROY,

	ERDMA_STATS_IW_ACCEPT,
	ERDMA_STATS_IW_ACCEPT_SUCCESS,
	ERDMA_STATS_IW_ACCEPT_FAILED,

	ERDMA_STATS_IW_REJECT,
	ERDMA_STATS_IW_REJECT_FAILED,
	ERDMA_STATS_IW_CONNECT,
	ERDMA_STATS_IW_CONNECT_SUCCESS,
	ERDMA_STATS_IW_CONNECT_FAILED,
	ERDMA_STATS_IW_CONNECT_TIMEOUT,
	ERDMA_STATS_IW_CONNECT_RST,

	ERDMA_STATS_CMDQ_SUBMITTED,
	ERDMA_STATS_CMDQ_COMP,
	ERDMA_STATS_CMDQ_EQ_NOTIFY,
	ERDMA_STATS_CMDQ_EQ_EVENT,
	ERDMA_STATS_CMDQ_CQ_ARMED,

	ERDMA_STATS_AEQ_EVENT,
	ERDMA_STATS_AEQ_NOTIFY,

	ERDMA_STATS_CMD_ALLOC_MR,
	ERDMA_STATS_CMD_ALLOC_MR_FAILED,
	ERDMA_STATS_CMD_ALLOC_PD,
	ERDMA_STATS_CMD_ALLOC_PD_FAILED,
	ERDMA_STATS_CMD_ALLOC_UCTX,
	ERDMA_STATS_CMD_ALLOC_UCTX_FAILED,

	ERDMA_STATS_CMD_CREATE_CQ,
	ERDMA_STATS_CMD_CREATE_CQ_FAILED,
	ERDMA_STATS_CMD_CREATE_QP,
	ERDMA_STATS_CMD_CREATE_QP_FAILED,

	ERDMA_STATS_CMD_DEALLOC_PD,
	ERDMA_STATS_CMD_DEALLOC_UCTX,
	ERDMA_STATS_CMD_DEREG_MR,
	ERDMA_STATS_CMD_DEREG_MR_FAILED,
	ERDMA_STATS_CMD_DESTROY_CQ,
	ERDMA_STATS_CMD_DESTROY_CQ_FAILED,
	ERDMA_STATS_CMD_DESTROY_QP,
	ERDMA_STATS_CMD_DESTROY_QP_FAILED,

	ERDMA_STATS_CMD_GET_DMA_MR,
	ERDMA_STATS_CMD_GET_DMA_MR_FAILED,
	ERDMA_STATS_CMD_REG_USR_MR,
	ERDMA_STATS_CMD_REG_USR_MR_FAILED,

	ERDMA_STATS_TX_REQS_CNT,
	ERDMA_STATS_TX_PACKETS_CNT,
	ERDMA_STATS_TX_BYTES_CNT,
	ERDMA_STATS_TX_DISABLE_DROP_CNT,
	ERDMA_STATS_TX_BPS_METER_DROP_CNT,
	ERDMA_STATS_TX_PPS_METER_DROP_CNT,

	ERDMA_STATS_RX_PACKETS_CNT,
	ERDMA_STATS_RX_BYTES_CNT,
	ERDMA_STATS_RX_DISABLE_DROP_CNT,
	ERDMA_STATS_RX_BPS_METER_DROP_CNT,
	ERDMA_STATS_RX_PPS_METER_DROP_CNT,

	ERDMA_STATS_MAX
};

struct rdma_hw_stats *erdma_alloc_hw_stats(struct ib_device *ibdev,
					   port_t port_num);
int erdma_get_hw_stats(struct ib_device *ibdev, struct rdma_hw_stats *stats,
		       port_t port_num, int index);

#endif
