/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/// Namespace for user metrics
///
/// This is extended by user code (generated by the `glean_parser`).
///
/// # Example
///
/// ```swift
/// extension GleanMetrics {
///     enum Search {
///         /// Running ping counter for this ping. This works as a sequence number to allow
///         /// detecting for missing send_in_pings.
///         static let counts = CounterMetricType(
///             category: "search",
///             name: "counts",
///             sendInPings: ["metrics"],
///             lifetime: .application,
///             disabled: false
///         )
///     }
/// }
/// ```
///
/// This will be used by the user as following:
///
/// ```swift
/// import Glean
///
/// GleanMetrics.Search.counts.add(1)
/// ```
public enum GleanMetrics {}
