; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

@G1 = constant i32 0
@G2 = constant ptr @G1

;.
; CHECK: @[[G1:[a-zA-Z0-9_$"\\.-]+]] = constant i32 0
; CHECK: @[[G2:[a-zA-Z0-9_$"\\.-]+]] = constant ptr @G1
;.
define internal i32 @test(ptr %x) {
;
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@test
; CHECK-SAME: () #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[Z:%.*]] = load i32, ptr @G1, align 4
; CHECK-NEXT:    ret i32 [[Z]]
;
entry:
  %y = load ptr, ptr %x
  %z = load i32, ptr %y
  ret i32 %z
}

define i32 @caller() {
; TUNIT: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@caller
; TUNIT-SAME: () #[[ATTR0]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[X:%.*]] = call i32 @test() #[[ATTR1:[0-9]+]]
; TUNIT-NEXT:    ret i32 [[X]]
;
; CGSCC: Function Attrs: mustprogress nofree nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@caller
; CGSCC-SAME: () #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[X:%.*]] = call i32 @test() #[[ATTR2:[0-9]+]]
; CGSCC-NEXT:    ret i32 [[X]]
;
entry:
  %x = call i32 @test(ptr @G2)
  ret i32 %x
}

;.
; TUNIT: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR1]] = { nofree nosync nounwind willreturn memory(read) }
;.
; CGSCC: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR1]] = { mustprogress nofree nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR2]] = { nofree willreturn }
;.
