; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

target datalayout = "A7"

; Make sure we create allocas in AS 7 and cast them properly.

define i32 @bar(i32 %arg) {
; TUNIT-LABEL: define {{[^@]+}}@bar
; TUNIT-SAME: (i32 [[ARG:%.*]]) {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[STACK:%.*]] = alloca i32, align 4
; TUNIT-NEXT:    store i32 [[ARG]], ptr [[STACK]], align 4
; TUNIT-NEXT:    [[TMP0:%.*]] = load i32, ptr [[STACK]], align 4
; TUNIT-NEXT:    [[CALL:%.*]] = call i32 @foo(i32 [[TMP0]])
; TUNIT-NEXT:    ret i32 [[CALL]]
;
; CGSCC-LABEL: define {{[^@]+}}@bar
; CGSCC-SAME: (i32 [[ARG:%.*]]) {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[STACK:%.*]] = alloca i32, align 4
; CGSCC-NEXT:    store i32 [[ARG]], ptr [[STACK]], align 4
; CGSCC-NEXT:    [[CALL:%.*]] = call i32 @foo(i32 [[ARG]])
; CGSCC-NEXT:    ret i32 [[CALL]]
;
entry:
  %stack = alloca i32
  store i32 %arg, ptr %stack
  %call = call i32 @foo(ptr %stack)
  ret i32 %call
}

define internal i32 @foo(ptr %arg) {
; CHECK-LABEL: define {{[^@]+}}@foo
; CHECK-SAME: (i32 [[TMP0:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ARG_PRIV:%.*]] = alloca i32, align 4, addrspace(7)
; CHECK-NEXT:    store i32 [[TMP0]], ptr addrspace(7) [[ARG_PRIV]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = addrspacecast ptr addrspace(7) [[ARG_PRIV]] to ptr
; CHECK-NEXT:    [[L:%.*]] = load i32, ptr [[TMP1]], align 4
; CHECK-NEXT:    call void @use(i32 [[L]])
; CHECK-NEXT:    ret i32 [[L]]
;
entry:
  %l = load i32, ptr %arg
  call void @use(i32 %l)
  ret i32 %l
}

declare void @use(i32)
