// Generated by CoffeeScript 2.5.1
var DefaultLinePrependor, SpecialString, tools;

tools = require('../../../tools');

SpecialString = require('../../SpecialString');

module.exports = DefaultLinePrependor = (function() {
  var self;

  class DefaultLinePrependor extends require('./_LinePrependor') {
    static pad(howMuch) {
      return tools.repeatString(" ", howMuch);
    }

    _render(inherited, options) {
      var addToLeft, addToRight, alignment, bullet, char, charLen, diff, left, output, space, toWrite;
      if (this._lineNo === 0 && (bullet = this._config.bullet)) {
        char = bullet.char;
        charLen = new SpecialString(char).length;
        alignment = bullet.alignment;
        space = this._config.amount;
        toWrite = char;
        addToLeft = '';
        addToRight = '';
        if (space > charLen) {
          diff = space - charLen;
          if (alignment === 'right') {
            addToLeft = self.pad(diff);
          } else if (alignment === 'left') {
            addToRight = self.pad(diff);
          } else if (alignment === 'center') {
            left = Math.round(diff / 2);
            addToLeft = self.pad(left);
            addToRight = self.pad(diff - left);
          } else {
            throw Error(`Unknown alignment \`${alignment}\``);
          }
        }
        output = addToLeft + char + addToRight;
      } else {
        output = self.pad(this._config.amount);
      }
      return inherited + output;
    }

  };

  self = DefaultLinePrependor;

  return DefaultLinePrependor;

}).call(this);
